/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.constants.GuiComponentType;
import noppes.npcs.api.gui.IGuiTimer;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;
import noppes.npcs.util.Util;

public class CustomGuiTimerWrapper
extends CustomGuiComponentWrapper
implements IGuiTimer {
    int color = 0xFFFFFF;
    public long start = 0L;
    public long now = 0L;
    public long end = 0L;
    float scale = 1.0f;
    int width;
    int height;
    public boolean reverse;

    public CustomGuiTimerWrapper() {
    }

    public CustomGuiTimerWrapper(int id, long start, long end, int x, int y, int width, int height) {
        this();
        this.setId(id);
        this.setPos(x, y);
        this.setSize(width, height);
        this.setTime(start, end);
    }

    public CustomGuiTimerWrapper(int id, long start, long end, int x, int y, int width, int height, int color) {
        this(id, start, end, x, y, width, height);
        this.setColor(color);
    }

    @Override
    public CustomGuiComponentWrapper fromNBT(NBTTagCompound nbt) {
        super.fromNBT(nbt);
        this.setSize(nbt.func_74759_k("size")[0], nbt.func_74759_k("size")[1]);
        this.setColor(nbt.func_74762_e("color"));
        this.setScale(nbt.func_74760_g("scale"));
        long s = nbt.func_74763_f("start");
        long e = nbt.func_74763_f("end");
        if (s != this.start || e != this.end || this.now == 0L) {
            this.setTime(s, e);
        }
        return this;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public String getText() {
        long time = this.reverse ? this.now - System.currentTimeMillis() : System.currentTimeMillis() - this.now;
        return Util.instance.ticksToElapsedTime(time /= 50L, false, false, false);
    }

    @Override
    public int getType() {
        return GuiComponentType.TIMER.get();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public IGuiTimer setColor(int color) {
        this.color = color;
        return this;
    }

    @Override
    public IGuiTimer setScale(float scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public IGuiTimer setSize(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new CustomNPCsException("Invalid component width or height: [" + width + ", " + height + "]", new Object[0]);
        }
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public void setTime(long start, long end) {
        this.start = start;
        this.end = end;
        this.now = System.currentTimeMillis();
        this.reverse = start > end;
    }

    @Override
    public NBTTagCompound toNBT(NBTTagCompound nbt) {
        super.toNBT(nbt);
        nbt.func_74783_a("size", new int[]{this.width, this.height});
        nbt.func_74768_a("color", this.color);
        nbt.func_74776_a("scale", this.scale);
        nbt.func_74772_a("start", this.start);
        nbt.func_74772_a("end", this.end);
        nbt.func_74757_a("Reverse", this.reverse);
        return nbt;
    }
}

